	function h = IDEAL_IMPULSE_DIFF_Z(WcT, N)
 
	% 	Computes impulse response of an ideal digital differentiator
	% 	with cutoff angle wcT. The length of the impulse response is N
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2008-07-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	%	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	
	M = (N-1)/2;
	for k = -M:M
		if k == 0
			h(k+M+1) = 0;
		else
			h(k+M+1) = WcT*cos(WcT*k)/(pi*k) - sin(WcT*k)/(pi*k^2);
		end
	end
